package ru.yandex.partner.core.entity.designtemplates.actions.all;

import java.util.Map;
import java.util.Set;

import com.fasterxml.jackson.databind.ObjectMapper;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.action.ActionConfiguration;
import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.helper.ActionOptsHelper;
import ru.yandex.partner.core.entity.designtemplates.actions.DesignTemplatesAction;
import ru.yandex.partner.core.entity.designtemplates.model.DesignTemplates;
import ru.yandex.partner.core.multistate.designtemplates.DesignTemplatesStateFlag;
import ru.yandex.partner.libs.multistate.graph.MultistateGraph;

public class DesignTemplatesActionAdd extends DesignTemplatesAction {
    private final Map<Long, DesignTemplates> addedModels;
    private final Map<Long, Set<ModelProperty<? super DesignTemplates, ?>>> addedProperties;
    private final ObjectMapper objectMapper;

    @SuppressWarnings("ParameterNumber")
    public DesignTemplatesActionAdd(
            ActionConfiguration<DesignTemplates, ?> parentFactory,
            String name,
            Map<Long, DesignTemplates> addedModels,
            Map<Long, Set<ModelProperty<? super DesignTemplates, ?>>> addedProperties,
            MultistateGraph<DesignTemplates, DesignTemplatesStateFlag> multistateGraph,
            ActionPerformer actionPerformer,
            ActionErrorHandler<DesignTemplates> actionErrorHandler,
            ObjectMapper objectMapper
    ) {
        super(
                parentFactory,
                name,
                addedProperties.keySet(),
                multistateGraph,
                actionPerformer,
                actionErrorHandler
        );
        this.addedModels = addedModels;
        this.addedProperties = addedProperties;
        this.objectMapper = objectMapper;
    }

    @Override
    public String getSerializedOpts(Long id) {
        var addedModel = addedModels.get(id);
        Set<ModelProperty<? super DesignTemplates, ?>> changedProps = addedProperties.get(id);
        return ActionOptsHelper.getSerializedOptsForAdd(id,
                objectMapper, getName(), getEntityClass(), addedModel, changedProps);
    }
}
