package ru.yandex.partner.core.entity.designtemplates.actions.all;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.databind.ObjectMapper;

import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.action.ActionConfiguration;
import ru.yandex.partner.core.action.ActionContext;
import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionModelContainerImpl;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.helper.ActionOptsHelper;
import ru.yandex.partner.core.entity.designtemplates.actions.DesignTemplatesAction;
import ru.yandex.partner.core.entity.designtemplates.model.DesignTemplates;
import ru.yandex.partner.core.multistate.designtemplates.DesignTemplatesStateFlag;
import ru.yandex.partner.defaultconfiguration.PartnerLocalDateTime;
import ru.yandex.partner.libs.multistate.graph.MultistateGraph;

@ParametersAreNonnullByDefault
public class DesignTemplatesActionEdit extends DesignTemplatesAction {
    private final Map<Long, ModelChanges<DesignTemplates>> modelChangesMap;
    private final ObjectMapper objectMapper;

    @SuppressWarnings("ParameterNumber")
    public DesignTemplatesActionEdit(ActionConfiguration<DesignTemplates, ?> parentFactory,
                                     String name,
                                     Collection<ModelChanges<DesignTemplates>> modelChangesMap,
                                     MultistateGraph<DesignTemplates, DesignTemplatesStateFlag> multistateGraph,
                                     ActionPerformer actionPerformer,
                                     ActionErrorHandler<DesignTemplates> actionErrorHandler,
                                     ObjectMapper objectMapper) {
        this(parentFactory, name,
                modelChangesMap.stream().collect(Collectors.toMap(ModelChanges::getId, Function.identity())),
                multistateGraph, actionPerformer, actionErrorHandler, objectMapper);
    }

    @SuppressWarnings("ParameterNumber")
    private DesignTemplatesActionEdit(ActionConfiguration<DesignTemplates, ?> parentFactory,
                                      String name,
                                      Map<Long, ModelChanges<DesignTemplates>> modelChangesMap,
                                      MultistateGraph<DesignTemplates, DesignTemplatesStateFlag> multistateGraph,
                                      ActionPerformer actionPerformer,
                                      ActionErrorHandler<DesignTemplates> errorHandler,
                                      ObjectMapper objectMapper) {
        super(parentFactory, name, modelChangesMap.keySet(), multistateGraph, actionPerformer, errorHandler);
        this.objectMapper = objectMapper;
        this.modelChangesMap = modelChangesMap;
    }

    @Override
    public Set<ModelProperty<?, ?>> getDependsOn() {
        var stream1 = super.getDependsOn().stream();
        var stream2 = modelChangesMap.values().stream().map(ModelChanges::getChangedPropsNames).flatMap(Set::stream);

        return Stream.concat(stream1, stream2).collect(Collectors.toSet());
    }

    @Override
    public String getSerializedOpts(Long id) {
        return ActionOptsHelper.prepareSerializedOptsForUpdated(this.modelChangesMap.getOrDefault(id, null),
                objectMapper, DesignTemplates.class);
    }

    @Override
    public void onAction(ActionContext<DesignTemplates, ActionModelContainerImpl<DesignTemplates>> ctx,
                         List<ActionModelContainerImpl<DesignTemplates>> containers) {
        var now = PartnerLocalDateTime.now();
        for (ActionModelContainerImpl<DesignTemplates> container : containers) {
            container.changeProperty(DesignTemplates.UPDATE_TIME, now);

            ModelChanges<DesignTemplates> modelChanges =
                    this.getModelChangesById(container.getProperty(DesignTemplates.ID));

            modelChanges.getChangedPropsNames().forEach(modelProperty -> container.changeProperty(
                    (ModelProperty<DesignTemplates, Object>) modelProperty,
                    modelChanges.getChangedProp(modelProperty)
            ));
        }
    }

    public ModelChanges<DesignTemplates> getModelChangesById(Long id) {
        return Objects.requireNonNull(modelChangesMap.get(id),
                "Edit action: No changes found for model: " + id);
    }
}
