package ru.yandex.partner.core.entity.designtemplates.actions.all.factories;

import java.util.List;
import java.util.Map;
import java.util.Set;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.ActionAddFactory;
import ru.yandex.partner.core.action.factories.CustomPayloadActionFactory;
import ru.yandex.partner.core.entity.block.actions.BlockActionsEnum;
import ru.yandex.partner.core.entity.designtemplates.actions.DesignTemplatesActionsEnum;
import ru.yandex.partner.core.entity.designtemplates.actions.all.DesignTemplatesActionAdd;
import ru.yandex.partner.core.entity.designtemplates.model.DesignTemplates;
import ru.yandex.partner.core.multistate.designtemplates.DesignTemplatesStateFlag;
import ru.yandex.partner.libs.multistate.graph.MultistateGraph;

@Component
public class DesignTemplatesActionAddFactory extends
        CustomPayloadActionFactory<DesignTemplates, DesignTemplatesActionAdd>
        implements ActionAddFactory<DesignTemplates> {
    private final MultistateGraph<DesignTemplates, DesignTemplatesStateFlag> multistateGraph;
    private final ActionPerformer actionPerformer;
    private final ActionErrorHandler<DesignTemplates> actionErrorHandler;
    private final ObjectMapper objectMapper;

    public DesignTemplatesActionAddFactory(
            MultistateGraph<DesignTemplates, DesignTemplatesStateFlag> multistateGraph,
            ActionPerformer actionPerformer,
            ActionErrorHandler<DesignTemplates> actionErrorHandler,
            ObjectMapper objectMapper) {
        super(DesignTemplatesActionsEnum.ADD, multistateGraph);
        this.multistateGraph = multistateGraph;
        this.actionPerformer = actionPerformer;
        this.actionErrorHandler = actionErrorHandler;
        this.objectMapper = objectMapper;
    }

    @Override
    public String getName() {
        return BlockActionsEnum.ADD.getActionName();
    }

    @Override
    public DesignTemplatesActionAdd createAction(
            Map<Long, DesignTemplates> addedModels,
            Map<Long, Set<ModelProperty<? super DesignTemplates, ?>>> addedProps
    ) {
        return new DesignTemplatesActionAdd(
                getActionConfiguration(),
                getName(),
                addedModels,
                addedProps,
                multistateGraph,
                actionPerformer,
                actionErrorHandler,
                objectMapper
        );
    }

    @Override
    public DesignTemplatesActionAdd createAction(List<Long> ids, JsonNode payload) {
        throw new UnsupportedOperationException("DesignTemplatesAddFactory#createAction");
    }

    @Override
    public Class<DesignTemplates> getModelClass() {
        return DesignTemplates.class;
    }
}
