package ru.yandex.partner.core.entity.designtemplates.actions.all.factories;

import java.util.Collection;
import java.util.List;

import com.fasterxml.jackson.databind.JsonNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.CustomPayloadActionFactory;
import ru.yandex.partner.core.entity.designtemplates.actions.DesignTemplatesActionsEnum;
import ru.yandex.partner.core.entity.designtemplates.actions.all.DesignTemplatesActionDelete;
import ru.yandex.partner.core.entity.designtemplates.model.DesignTemplates;
import ru.yandex.partner.core.entity.designtemplates.multistate.DesignTemplatesMultistateGraph;

@Component
public class DesignTemplatesDeleteFactory extends CustomPayloadActionFactory<DesignTemplates,
        DesignTemplatesActionDelete> {
    private final DesignTemplatesMultistateGraph multistateGraph;
    private final ActionPerformer actionPerformer;
    private final ActionErrorHandler<DesignTemplates> errorHandler;

    @Autowired
    public DesignTemplatesDeleteFactory(
            DesignTemplatesMultistateGraph multistateGraph,
            ActionPerformer actionPerformer,
            ActionErrorHandler<DesignTemplates> errorHandler) {
        super(DesignTemplatesActionsEnum.DELETE, multistateGraph);
        this.multistateGraph = multistateGraph;
        this.actionPerformer = actionPerformer;
        this.errorHandler = errorHandler;
    }

    @Override
    public DesignTemplatesActionDelete createAction(List<Long> ids, JsonNode payload) {
        return delete(ids);
    }

    @Override
    public String getName() {
        return DesignTemplatesActionsEnum.DELETE.getActionName();
    }

    public DesignTemplatesActionDelete delete(Collection<Long> ids) {
        return new DesignTemplatesActionDelete(
                getActionConfiguration(),
                getName(),
                ids,
                multistateGraph,
                actionPerformer,
                errorHandler);
    }

    @Override
    public Class<DesignTemplates> getModelClass() {
        return DesignTemplates.class;
    }
}
