package ru.yandex.partner.core.entity.designtemplates.actions.all.factories;

import java.util.Collection;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelChanges;
import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.ModelPayloadActionFactory;
import ru.yandex.partner.core.entity.IncomingFields;
import ru.yandex.partner.core.entity.designtemplates.actions.DesignTemplatesActionsEnum;
import ru.yandex.partner.core.entity.designtemplates.actions.all.DesignTemplatesActionEdit;
import ru.yandex.partner.core.entity.designtemplates.model.DesignTemplates;
import ru.yandex.partner.core.entity.designtemplates.multistate.DesignTemplatesMultistateGraph;

@Component
public class DesignTemplatesEditFactory
        extends ModelPayloadActionFactory<DesignTemplates, DesignTemplatesActionEdit> {
    private final DesignTemplatesMultistateGraph multistateGraph;
    private final ActionPerformer actionPerformer;
    private final ObjectMapper objectMapper;
    private final ActionErrorHandler<DesignTemplates> errorHandler;

    @Autowired
    public DesignTemplatesEditFactory(
            DesignTemplatesEditConfigurationFactory factory,
            DesignTemplatesMultistateGraph multistateGraph,
            ActionPerformer actionPerformer,
            ObjectMapper objectMapper,
            ActionErrorHandler<DesignTemplates> errorHandler) {
        super(factory);
        this.multistateGraph = multistateGraph;
        this.actionPerformer = actionPerformer;
        this.objectMapper = objectMapper;
        this.errorHandler = errorHandler;
    }

    @Override
    public DesignTemplatesActionEdit createAction(
            Collection<ModelChanges<? super DesignTemplates>> modelChanges,
            IncomingFields updatedFields
    ) {
        return edit(modelChanges);
    }

    @Override
    public String getName() {
        return DesignTemplatesActionsEnum.EDIT.getActionName();
    }

    public DesignTemplatesActionEdit edit(
            Collection<? extends ModelChanges<? super DesignTemplates>> modelChanges) {
        return new DesignTemplatesActionEdit(
                getActionConfiguration(),
                getName(),
                modelChanges.stream().map(it -> it.castModel(DesignTemplates.class)).collect(Collectors.toList()),
                multistateGraph,
                actionPerformer,
                errorHandler,
                objectMapper);
    }

    @Override
    public Class<DesignTemplates> getModelClass() {
        return DesignTemplates.class;
    }
}
