package ru.yandex.partner.core.entity.designtemplates.container;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.multitype.repository.container.RepositoryContainer;
import ru.yandex.direct.multitype.service.type.update.UpdateOperationContainer;
import ru.yandex.partner.core.entity.IncomingFields;
import ru.yandex.partner.core.entity.block.container.IncomingFieldsContainer;
import ru.yandex.partner.core.entity.block.service.OperationMode;
import ru.yandex.partner.core.entity.designtemplates.model.BaseDesignTemplates;
import ru.yandex.partner.core.operation.container.ModeContainer;

@ParametersAreNonnullByDefault
public class DesignTemplatesOperationContainer implements RepositoryContainer,
        UpdateOperationContainer<BaseDesignTemplates>, IncomingFieldsContainer, ModeContainer {

    private OperationMode mode;
    private IncomingFields incomingFields;

    private DesignTemplatesOperationContainer(OperationMode mode) {
        this.mode = mode;
    }

    public static DesignTemplatesOperationContainer create() {
        return create(OperationMode.ADD);
    }

    public static DesignTemplatesOperationContainer create(OperationMode mode) {
        return new DesignTemplatesOperationContainer(mode);
    }

    @Override
    public int getShard() {
        return 0;
    }

    @Override
    public Class<BaseDesignTemplates> getRuntimeClass(Long modelId) {
        return BaseDesignTemplates.class;
    }

    @Override
    public IncomingFields getIncomingFields() {
        return incomingFields;
    }

    @Override
    public void setIncomingFields(IncomingFields incomingFields) {
        this.incomingFields = incomingFields;
    }

    @Override
    public OperationMode getMode() {
        return mode;
    }
}
