package ru.yandex.partner.core.entity.designtemplates.filter;

import ru.yandex.partner.core.entity.designtemplates.model.BaseDesignTemplates;
import ru.yandex.partner.core.filter.dbmeta.NumberFilter;
import ru.yandex.partner.core.filter.dbmeta.PageBlockIdFilter;
import ru.yandex.partner.core.filter.dbmeta.StringFilter;
import ru.yandex.partner.core.filter.meta.MultistateMetaFilter;
import ru.yandex.partner.core.multistate.designtemplates.DesignTemplatesStateFlag;

import static ru.yandex.partner.dbschema.partner.tables.DesignTemplates.DESIGN_TEMPLATES;


public class DesignTemplatesFilters {

    public static final NumberFilter<BaseDesignTemplates, Long> ID = new NumberFilter<>("id",
            BaseDesignTemplates.class, DESIGN_TEMPLATES.ID);

    public static final NumberFilter<BaseDesignTemplates, Long> BLOCK_ID = new NumberFilter<>("block_id",
            BaseDesignTemplates.class, DESIGN_TEMPLATES.BLOCK_ID);

    public static final NumberFilter<BaseDesignTemplates, Long> PAGE_ID = new NumberFilter<>("page_id",
            BaseDesignTemplates.class, DESIGN_TEMPLATES.PAGE_ID);

    public static final MultistateMetaFilter<BaseDesignTemplates, DesignTemplatesStateFlag> MULTISTATE =
            new MultistateMetaFilter<>("multistate", BaseDesignTemplates.class);

    public static final StringFilter<BaseDesignTemplates> CAPTION = new StringFilter<>("caption",
            BaseDesignTemplates.class, DESIGN_TEMPLATES.CAPTION);

    public static final PageBlockIdFilter<BaseDesignTemplates> PAGE_BLOCK_ID_FILTER = new PageBlockIdFilter<>(
            "page_block_id_filter", BaseDesignTemplates.class,
            DESIGN_TEMPLATES.PAGE_ID, DESIGN_TEMPLATES.BLOCK_ID);

    private DesignTemplatesFilters() {
    }
}
