package ru.yandex.partner.core.entity.designtemplates.filter;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.designtemplates.model.DesignTemplates;
import ru.yandex.partner.core.entity.designtemplates.multistate.DesignTemplatesMultistateGraph;
import ru.yandex.partner.core.filter.db.MultistateDbFilter;
import ru.yandex.partner.core.multistate.designtemplates.DesignTemplatesStateFlag;
import ru.yandex.partner.dbschema.partner.Tables;

@Component
public class DesignTemplatesMultistateDbFilter extends MultistateDbFilter<DesignTemplates, DesignTemplatesStateFlag> {

    @Autowired
    public DesignTemplatesMultistateDbFilter(DesignTemplatesMultistateGraph multistateGraph) {
        super(DesignTemplatesFilters.MULTISTATE, DesignTemplates.class, multistateGraph,
                Tables.DESIGN_TEMPLATES.MULTISTATE);
    }
}
