package ru.yandex.partner.core.entity.designtemplates.multistate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.designtemplates.actions.DesignTemplatesActionsEnum;
import ru.yandex.partner.core.entity.designtemplates.model.DesignTemplates;
import ru.yandex.partner.core.messages.DesignTemplatesActionMsg;
import ru.yandex.partner.core.multistate.Multistate;
import ru.yandex.partner.core.multistate.designtemplates.DesignTemplatesMultistate;
import ru.yandex.partner.core.multistate.designtemplates.DesignTemplatesStateFlag;
import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.multistate.action.ActionEntry;
import ru.yandex.partner.libs.multistate.action.ActionNameHolder;
import ru.yandex.partner.libs.multistate.graph.AbstractMultistateGraph;

import static java.util.function.Predicate.not;
import static ru.yandex.partner.libs.multistate.MultistatePredicates.empty;
import static ru.yandex.partner.libs.multistate.MultistatePredicates.has;

@Component
public class DesignTemplatesMultistateGraph extends AbstractMultistateGraph<DesignTemplates, DesignTemplatesStateFlag> {

    @Override
    public Multistate<DesignTemplatesStateFlag> getMultistateFromModel(DesignTemplates model) {
        return model.getMultistate();
    }

    @Override
    protected Multistate<DesignTemplatesStateFlag> getMultistateForValue(Long multistateValue) {
        return new DesignTemplatesMultistate(multistateValue);
    }

    @Override
    protected Map<ActionNameHolder, ActionEntry<DesignTemplates, DesignTemplatesStateFlag>> createGraph() {
        Map<ActionNameHolder, ActionEntry<DesignTemplates, DesignTemplatesStateFlag>> actionEntryMap = new HashMap<>();
        actionEntryMap.put(DesignTemplatesActionsEnum.ADD,
                getActionEntryBuilder(DesignTemplatesActionMsg.ADD)
                        .setPredicate(empty())
                        .build());

        actionEntryMap.put(DesignTemplatesActionsEnum.DELETE,
                getActionEntryBuilder(DesignTemplatesActionMsg.ARCHIVE)
                        .setPredicate(not(has(DesignTemplatesStateFlag.DELETED)))
                        .setSetFlags(Map.of(
                                DesignTemplatesStateFlag.DELETED, true
                        ))
                        .build());

        actionEntryMap.put(DesignTemplatesActionsEnum.EDIT,
                getActionEntryBuilder(DesignTemplatesActionMsg.EDIT)
                        .setPredicate(not(has(DesignTemplatesStateFlag.DELETED)))
                        .build());

        actionEntryMap.put(DesignTemplatesActionsEnum.RESTORE,
                getActionEntryBuilder(DesignTemplatesActionMsg.RESTORE)
                        .setPredicate(has(DesignTemplatesStateFlag.DELETED))
                        .setSetFlags(Map.of(
                                DesignTemplatesStateFlag.DELETED, false
                        ))
                        .build());

        return actionEntryMap;
    }

    private ActionEntry.Builder<DesignTemplates, DesignTemplatesStateFlag> getActionEntryBuilder(GettextMsg titleMsg) {
        return getActionEntryBuilder(titleMsg, Set.of(DesignTemplates.ID, DesignTemplates.MULTISTATE));
    }

    @Override
    public Class<DesignTemplates> getModelClass() {
        return DesignTemplates.class;
    }

    @Override
    public Multistate<DesignTemplatesStateFlag> convertMultistate(List<DesignTemplatesStateFlag> enabledFlags) {
        return new DesignTemplatesMultistate(enabledFlags);
    }
}
