package ru.yandex.partner.core.entity.designtemplates.repository;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.jooq.DSLContext;
import org.jooq.Table;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;
import ru.yandex.direct.multitype.repository.RepositoryTypeSupportFacade;
import ru.yandex.direct.multitype.repository.TypeModifyRepository;
import ru.yandex.direct.multitype.repository.TypedRepository;
import ru.yandex.direct.multitype.repository.filter.Filter;
import ru.yandex.partner.core.configuration.DslContextProviderStub;
import ru.yandex.partner.core.designtemplates.DesignTemplatesType;
import ru.yandex.partner.core.entity.designtemplates.container.DesignTemplatesOperationContainer;
import ru.yandex.partner.core.entity.designtemplates.model.BaseDesignTemplates;

import static ru.yandex.direct.multitype.repository.filter.ConditionFilterFactory.whereInFilter;
import static ru.yandex.partner.dbschema.partner.tables.DesignTemplates.DESIGN_TEMPLATES;

@Repository
public class DesignTemplatesModifyRepository extends TypeModifyRepository<BaseDesignTemplates, BaseDesignTemplates,
        DesignTemplatesOperationContainer, DesignTemplatesOperationContainer> {

    private final RepositoryTypeSupportFacade<BaseDesignTemplates, DesignTemplatesType,
            DesignTemplatesOperationContainer, DesignTemplatesOperationContainer> typeSupportFacade;

    @Autowired
    public DesignTemplatesModifyRepository(DSLContext dslContext,
                                           RepositoryTypeSupportFacade<BaseDesignTemplates, DesignTemplatesType,
                                                   DesignTemplatesOperationContainer,
                                                   DesignTemplatesOperationContainer> typeSupportFacade,
                                           TypedRepository<BaseDesignTemplates, ?,
                                                   DesignTemplatesOperationContainer,
                                                   DesignTemplatesOperationContainer> typedRepository) {
        super(new DslContextProviderStub(dslContext), typeSupportFacade, typedRepository);
        this.typeSupportFacade = typeSupportFacade;
    }

    @Override
    public List<Long> add(DSLContext context, DesignTemplatesOperationContainer addContainer,
                          List<? extends BaseDesignTemplates> models) {
        List<Long> insertedIds = context.transactionResult(configuration -> {
            DSLContext dsl = configuration.dsl();
            InsertHelperAggregator insertHelperAggregator = new InsertHelperAggregator(dsl);
            typeSupportFacade.pushToInsert(insertHelperAggregator, models);
            return insertHelperAggregator.getOrCreate(DESIGN_TEMPLATES)
                    .executeIfRecordsAddedAndReturn(DESIGN_TEMPLATES.ID);
        });
        Iterator<Long> ids = insertedIds.iterator();
        models.forEach(model -> model.setId(ids.next()));
        return insertedIds;
    }

    @Override
    protected void generateIds(DesignTemplatesOperationContainer addContainer,
                               List<? extends BaseDesignTemplates> models) {
        //id генерится жуком
    }

    @Override
    protected Table<?> getLockTable() {
        return DESIGN_TEMPLATES;
    }

    @Override
    protected Filter getIdFilter(Collection<Long> modelIds) {
        return whereInFilter(DESIGN_TEMPLATES.ID, modelIds);
    }
}
