package ru.yandex.partner.core.entity.designtemplates.repository;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.designtemplates.DesignTemplatesType;
import ru.yandex.partner.core.entity.designtemplates.container.DesignTemplatesOperationContainer;
import ru.yandex.partner.core.entity.designtemplates.model.BaseDesignTemplates;
import ru.yandex.partner.core.entity.designtemplates.model.DesignTemplates;
import ru.yandex.partner.core.multitype.repository.PartnerRepositoryTypeSupportFacade;

@Component
@ParametersAreNonnullByDefault
public class DesignTemplatesRepositoryTypeSupportFacade extends PartnerRepositoryTypeSupportFacade<BaseDesignTemplates,
        DesignTemplatesType,
        DesignTemplatesOperationContainer, DesignTemplatesOperationContainer> {
    @Autowired
    public DesignTemplatesRepositoryTypeSupportFacade(List<DesignTemplatesRepositoryTypeSupport<?
            extends BaseDesignTemplates>> typeSupports) {
        super(typeSupports, DesignTemplates::new, Set.of(BaseDesignTemplates.class));
    }

    @Override
    protected DesignTemplatesType getModelType(Record record) {
        return DesignTemplatesType.DESIGN_TEMPLATES;
    }

}
