package ru.yandex.partner.core.entity.designtemplates.repository;

import java.util.Collection;

import org.jooq.DSLContext;
import org.jooq.Record1;
import org.jooq.SelectQuery;
import org.jooq.Table;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.multitype.repository.filter.Filter;
import ru.yandex.partner.core.designtemplates.DesignTemplatesType;
import ru.yandex.partner.core.entity.designtemplates.container.DesignTemplatesOperationContainer;
import ru.yandex.partner.core.entity.designtemplates.filter.DesignTemplatesFilters;
import ru.yandex.partner.core.entity.designtemplates.filter.DesignTemplatesModelFilterContainer;
import ru.yandex.partner.core.entity.designtemplates.model.BaseDesignTemplates;
import ru.yandex.partner.core.entity.designtemplates.model.CommonDesignTemplates;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.core.multitype.repository.PartnerTypedRepository;

import static ru.yandex.direct.multitype.repository.filter.ConditionFilterFactory.whereInFilter;
import static ru.yandex.partner.dbschema.partner.Tables.DESIGN_TEMPLATES;

@Repository
public class DesignTemplatesTypedRepository extends PartnerTypedRepository<BaseDesignTemplates, DesignTemplatesType,
        DesignTemplatesOperationContainer,
        DesignTemplatesOperationContainer> {

    @Autowired
    public DesignTemplatesTypedRepository(DSLContext dslContext,
                                          DesignTemplatesRepositoryTypeSupportFacade typeSupportFacade,
                                          DesignTemplatesModelFilterContainer modelFilterContainer) {
        super(dslContext, typeSupportFacade, modelFilterContainer);
    }

    @Override
    protected Filter getIdFilter(Collection<Long> modelIds) {
        return whereInFilter(DESIGN_TEMPLATES.ID, modelIds);
    }

    @Override
    protected Table<?> getBaseTable() {
        return DESIGN_TEMPLATES;
    }

    public <S extends CommonDesignTemplates> Long getCountByCondition(
            CoreFilterNode<? super S> coreFilterNode, Class<S> clazz) {
        SelectQuery<Record1<Integer>> query = getSelectCountQuery(this.dslContext, clazz);
        applyFilterToQuery(clazz, coreFilterNode, query);
        return query.fetchSingleInto(Long.class);
    }

    @Override
    protected <S extends BaseDesignTemplates> CoreFilterNode<S> getCoreFilterNodeById(Collection<Long> ids) {
        return CoreFilterNode.in(DesignTemplatesFilters.ID, ids);
    }

    @Override
    protected ModelProperty<? extends Model, Long> getIdModelProperty() {
        return BaseDesignTemplates.ID;
    }
}
