package ru.yandex.partner.core.entity.designtemplates.service;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.ModelQueryService;
import ru.yandex.partner.core.entity.Query;
import ru.yandex.partner.core.entity.designtemplates.filter.DesignTemplatesFilters;
import ru.yandex.partner.core.entity.designtemplates.model.CommonDesignTemplates;
import ru.yandex.partner.core.entity.designtemplates.repository.DesignTemplatesTypedRepository;
import ru.yandex.partner.core.entity.tasks.doaction.DoActionFilterEnum;
import ru.yandex.partner.core.filter.meta.MetaFilter;

import static ru.yandex.direct.multitype.typesupport.TypeFilteringUtils.filterModelsOfClass;

@ParametersAreNonnullByDefault
@Service
public class DesignTemplatesService implements ModelQueryService<CommonDesignTemplates> {
    private final DesignTemplatesTypedRepository typedRepository;

    @Autowired
    public DesignTemplatesService(DesignTemplatesTypedRepository typedRepository) {
        this.typedRepository = typedRepository;
    }

    @Override
    public <S extends CommonDesignTemplates> List<S> findAll(Query<S> opts) {
        return filterModelsOfClass(
                typedRepository.getAll(opts),
                opts.getClazz()
        );
    }

    @Override
    public <S extends CommonDesignTemplates> long count(Query<S> opts) {
        return typedRepository.getCountByCondition(opts.getFilter(), opts.getClazz());
    }

    @Override
    public ModelProperty<? extends Model, Long> getIdModelProperty() {
        return CommonDesignTemplates.ID;
    }

    @Override
    public Class<CommonDesignTemplates> getBaseClass() {
        return CommonDesignTemplates.class;
    }

    @Override
    public <S extends CommonDesignTemplates>
    MetaFilter<? super S, ?> getMetaFilterForDoAction(DoActionFilterEnum doActionFilterEnum) {

        return switch (doActionFilterEnum) {
            case PAGE_ID -> DesignTemplatesFilters.PAGE_ID;
            case MULTISTATE -> DesignTemplatesFilters.MULTISTATE;
        };
    }
}
