package ru.yandex.partner.core.entity.designtemplates.service.add;

import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.IncomingFields;
import ru.yandex.partner.core.entity.designtemplates.container.DesignTemplatesOperationContainer;
import ru.yandex.partner.core.entity.designtemplates.model.BaseDesignTemplates;
import ru.yandex.partner.core.entity.designtemplates.repository.DesignTemplatesModifyRepository;
import ru.yandex.partner.core.entity.designtemplates.service.validation.DesignTemplatesValidationTypeSupportFacade;
import ru.yandex.partner.core.operation.factory.PartnerAddOperationFactory;

@Component
public class DesignTemplatesAddOperationFactory extends PartnerAddOperationFactory<BaseDesignTemplates,
        DesignTemplatesOperationContainer, DesignTemplatesOperationContainer> {
    public DesignTemplatesAddOperationFactory(
            DSLContext dslContext,
            DesignTemplatesAddOperationTypeSupportFacade addOperationTypeSupportFacade,
            DesignTemplatesValidationTypeSupportFacade designTemplatesValidationTypeSupportFacade,
            DesignTemplatesModifyRepository designTemplatesModifyRepository
    ) {
        super(dslContext, addOperationTypeSupportFacade, designTemplatesValidationTypeSupportFacade,
                designTemplatesModifyRepository);
    }

    public DesignTemplatesOperationContainer prepareAddOperationContainer(IncomingFields incomingFields) {
        var container = DesignTemplatesOperationContainer.create();
        container.setIncomingFields(incomingFields);
        return container;
    }

}
