package ru.yandex.partner.core.entity.designtemplates.service.validation;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.direct.multitype.typesupport.TypeSupportAffectionHelper;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.PathNode;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.entity.designtemplates.container.DesignTemplatesOperationContainer;
import ru.yandex.partner.core.entity.designtemplates.model.BaseDesignTemplates;
import ru.yandex.partner.core.entity.designtemplates.repository.DesignTemplatesRepositoryTypeSupport;
import ru.yandex.partner.core.multitype.service.validation.type.ValidationTypeSupport;
import ru.yandex.partner.core.multitype.service.validation.type.ValidationTypeSupportFacade;

@Component
public class DesignTemplatesValidationTypeSupportFacade extends ValidationTypeSupportFacade<BaseDesignTemplates,
        DesignTemplatesOperationContainer, DesignTemplatesOperationContainer> {
    public DesignTemplatesValidationTypeSupportFacade(
            List<? extends ValidationTypeSupport<? extends BaseDesignTemplates,
                    DesignTemplatesOperationContainer>> validationTypeSupports,
            List<DesignTemplatesRepositoryTypeSupport<? extends BaseDesignTemplates>> typeSupports,
            TypeSupportAffectionHelper<BaseDesignTemplates> templatesTypeSupportAffectionHelper) {
        super(validationTypeSupports, typeSupports, templatesTypeSupportAffectionHelper,
                DesignTemplatesOperationContainer::create);
    }

    @Override
    public void addPreValidate(DesignTemplatesOperationContainer container,
                               ValidationResult<? extends List<? extends BaseDesignTemplates>, Defect> vr) {
        for (int i = 0; i < vr.getValue().size(); i++) {
            vr.addSubResult(new PathNode.Index(i), new ValidationResult<>(vr.getValue().get(i)));
        }
        super.addPreValidate(container, vr);
    }
}
