package ru.yandex.partner.core.entity.designtemplates.type.common;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.designtemplates.container.DesignTemplatesOperationContainer;
import ru.yandex.partner.core.entity.designtemplates.model.CommonDesignTemplates;
import ru.yandex.partner.core.entity.designtemplates.service.add.AbstractDesignTemplatesAddOperationTypeSupport;
import ru.yandex.partner.dbschema.partner.enums.DesignTemplatesType;
import ru.yandex.partner.defaultconfiguration.PartnerLocalDateTime;

@ParametersAreNonnullByDefault
@Component
public class CommonDesignTemplatesAddOperationTypeSupport
        extends AbstractDesignTemplatesAddOperationTypeSupport<CommonDesignTemplates> {

    @Override
    public Class<CommonDesignTemplates> getTypeClass() {
        return CommonDesignTemplates.class;
    }

    @Override
    public void onPreValidated(DesignTemplatesOperationContainer addContainer, List<CommonDesignTemplates> models) {
        var now = PartnerLocalDateTime.now();
        for (CommonDesignTemplates model : models) {
            // TODO move to default init on add
            if (model.getType() == null) {
                model.setType(DesignTemplatesType.tga);
            }

            if (model.getDesignSettings() != null) {
                model.setDesignSettings(DesignSettingsHelper.getFixedSettings(model.getDesignSettings()));
            }

            model.setUpdateTime(now);
        }
    }
}
