package ru.yandex.partner.core.entity.designtemplates.type.common;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.designtemplates.container.DesignTemplatesOperationContainer;
import ru.yandex.partner.core.entity.designtemplates.model.CommonDesignTemplates;
import ru.yandex.partner.core.entity.designtemplates.repository.AbstractDesignTemplatesRepositoryTypeSupport;
import ru.yandex.partner.core.holder.ModelPropertiesHolder;
import ru.yandex.partner.core.multistate.AbstractMultistate;
import ru.yandex.partner.core.multistate.designtemplates.DesignTemplatesMultistate;
import ru.yandex.partner.core.multitype.repository.PartnerRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.operation.CoreModelProvider;
import ru.yandex.partner.core.props.CoreModel;
import ru.yandex.partner.core.props.ModelPropertyDefault;
import ru.yandex.partner.core.utils.CommonConverters;
import ru.yandex.partner.dbschema.partner.enums.DesignTemplatesType;

import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.convertibleJsonProperty;
import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.jsonBooleanToLong;
import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.jsonString;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.partner.core.entity.common.prop.ModelWithBlockPageIdsBlockIdPropHolder.BLOCK_ID;
import static ru.yandex.partner.core.entity.common.prop.ModelWithBlockPageIdsPageIdPropHolder.PAGE_ID;
import static ru.yandex.partner.core.entity.designtemplates.model.prop.BaseDesignTemplatesIdPropHolder.ID;
import static ru.yandex.partner.core.entity.designtemplates.model.prop.CommonDesignTemplatesCaptionPropHolder.CAPTION;
import static ru.yandex.partner.core.entity.designtemplates.model.prop.CommonDesignTemplatesCustomFormatDirectPropHolder.CUSTOM_FORMAT_DIRECT;
import static ru.yandex.partner.core.entity.designtemplates.model.prop.CommonDesignTemplatesDesignSettingsPropHolder.DESIGN_SETTINGS;
import static ru.yandex.partner.core.entity.designtemplates.model.prop.CommonDesignTemplatesFilterTagsPropHolder.FILTER_TAGS;
import static ru.yandex.partner.core.entity.designtemplates.model.prop.CommonDesignTemplatesNativeTemplateFactorsPropHolder.NATIVE_TEMPLATE_FACTORS;
import static ru.yandex.partner.core.entity.designtemplates.model.prop.CommonDesignTemplatesPcodeKeyPropHolder.PCODE_KEY;
import static ru.yandex.partner.core.entity.designtemplates.model.prop.CommonDesignTemplatesStatLastDatePropHolder.STAT_LAST_DATE;
import static ru.yandex.partner.core.entity.designtemplates.model.prop.CommonDesignTemplatesTypePropHolder.TYPE;
import static ru.yandex.partner.core.entity.designtemplates.model.prop.CommonDesignTemplatesUpdateTimePropHolder.UPDATE_TIME;
import static ru.yandex.partner.core.entity.designtemplates.model.prop.DesignTemplatesMultistatePropHolder.MULTISTATE;
import static ru.yandex.partner.core.holder.ModelPropertiesHolder.fromModelProperties;
import static ru.yandex.partner.dbschema.partner.Tables.DESIGN_TEMPLATES;

@Component
public class CommonDesignTemplatesRepositoryTypeSupport
        extends AbstractDesignTemplatesRepositoryTypeSupport<CommonDesignTemplates>
        implements PartnerRepositoryTypeSupportWithMapper<CommonDesignTemplates, DesignTemplatesOperationContainer,
        DesignTemplatesOperationContainer>, CoreModelProvider<CommonDesignTemplates> {
    private static final CoreModel<CommonDesignTemplates> MODEL = CoreModel.forClass(CommonDesignTemplates.class)
            .property(ModelPropertyDefault.<CommonDesignTemplates, DesignTemplatesType>forProperty(TYPE)
                    .withDefaultValueOnAdd(DesignTemplatesType.tga)
            )
            .property(ModelPropertyDefault.<CommonDesignTemplates, DesignTemplatesMultistate>forProperty(MULTISTATE)
                    .mandatoryOnAdd(DesignTemplatesMultistate::new)
            )
            .build();

    private final Set<ModelProperty<? super CommonDesignTemplates, ?>> editableModelProperties;
    private final JooqMapper<CommonDesignTemplates> mapper;

    @Autowired
    public CommonDesignTemplatesRepositoryTypeSupport(DSLContext dslContext, ObjectMapper objectMapper) {
        super(dslContext);
        this.editableModelProperties = Set.of(PAGE_ID, BLOCK_ID, CAPTION, CUSTOM_FORMAT_DIRECT,
                FILTER_TAGS, TYPE, DESIGN_SETTINGS, NATIVE_TEMPLATE_FACTORS, PCODE_KEY);
        this.mapper = createDesignTemplatesMapper(objectMapper);

    }

    private static JooqMapper<CommonDesignTemplates> createDesignTemplatesMapper(ObjectMapper objectMapper) {
        return JooqMapperBuilder.<CommonDesignTemplates>builder()
                .map(property(ID, DESIGN_TEMPLATES.ID))
                .map(property(PAGE_ID, DESIGN_TEMPLATES.PAGE_ID))
                .map(property(BLOCK_ID, DESIGN_TEMPLATES.BLOCK_ID))
                .map(property(CAPTION, DESIGN_TEMPLATES.CAPTION))
                .map(property(TYPE, DESIGN_TEMPLATES.TYPE))
                .map(jsonBooleanToLong(CUSTOM_FORMAT_DIRECT, DESIGN_TEMPLATES.OPTS,
                        "is_custom_format_direct"))
                .map(convertibleJsonProperty(FILTER_TAGS, DESIGN_TEMPLATES.OPTS,
                        "filter_tags",
                        value -> CommonConverters.jsonNodeToList(objectMapper, value, String.class),
                        value -> CommonConverters.listToJsonNode(objectMapper, value)))
                .map(jsonString(STAT_LAST_DATE, DESIGN_TEMPLATES.OPTS, "stat_last_date"))
                .map(convertibleJsonProperty(DESIGN_SETTINGS, DESIGN_TEMPLATES.OPTS,
                        "design_settings",
                        value -> CommonConverters.jsonNodeToMap(objectMapper, value),
                        value -> CommonConverters.mapToJsonNode(objectMapper, value)))
                .map(jsonString(PCODE_KEY, DESIGN_TEMPLATES.OPTS, "pcode_key"))
                .map(convertibleJsonProperty(NATIVE_TEMPLATE_FACTORS, DESIGN_TEMPLATES.OPTS,
                        "native_template_factors",
                        value -> CommonConverters.jsonNodeToMap(objectMapper, value),
                        value -> CommonConverters.mapToJsonNode(objectMapper, value)))
                .map(convertibleProperty(MULTISTATE, DESIGN_TEMPLATES.MULTISTATE,
                        DesignTemplatesMultistate::new, AbstractMultistate::toMultistateValue))
                .map(property(UPDATE_TIME, DESIGN_TEMPLATES.UPDATE_TIME))
                .build();
    }

    @Override
    public JooqMapper<CommonDesignTemplates> getJooqMapper() {
        return mapper;
    }

    @Override
    public Class<CommonDesignTemplates> getTypeClass() {
        return CommonDesignTemplates.class;
    }

    @Override
    public ModelPropertiesHolder getEditableModelProperties(CommonDesignTemplates model) {
        return fromModelProperties(new HashSet<>(editableModelProperties));
    }

    @Override
    public void pushToInsert(InsertHelperAggregator insertHelperAggregator, CommonDesignTemplates model) {
        var helper = insertHelperAggregator.getOrCreate(DESIGN_TEMPLATES);
        helper.add(mapper, model);
    }

    @Override
    public void processUpdate(UpdateHelperAggregator updateHelperAggregator,
                              Collection<AppliedChanges<CommonDesignTemplates>> appliedChanges) {
        updateHelperAggregator.getOrCreate(DESIGN_TEMPLATES.ID).processUpdateAll(mapper, appliedChanges);
    }

    @Override
    public CoreModel<CommonDesignTemplates> getCoreModel() {
        return MODEL;
    }
}
