package ru.yandex.partner.core.entity.designtemplates.type.common;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Component;

import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.partner.core.designtemplates.DesignTemplatesType;
import ru.yandex.partner.core.entity.designtemplates.container.DesignTemplatesOperationContainer;
import ru.yandex.partner.core.entity.designtemplates.model.BaseDesignTemplates;
import ru.yandex.partner.core.entity.designtemplates.model.CommonDesignTemplates;
import ru.yandex.partner.core.entity.designtemplates.service.update.AbstractDesignTemplatesUpdateOperationTypeSupport;
import ru.yandex.partner.core.multitype.repository.PartnerRepositoryTypeSupportFacade;

@Component
public class CommonDesignTemplatesUpdateOperationTypeSupport
        extends AbstractDesignTemplatesUpdateOperationTypeSupport<CommonDesignTemplates> {

    public CommonDesignTemplatesUpdateOperationTypeSupport(
            PartnerRepositoryTypeSupportFacade<
                    BaseDesignTemplates,
                    DesignTemplatesType,
                    DesignTemplatesOperationContainer,
                    DesignTemplatesOperationContainer> repositoryFacade) {
        super(repositoryFacade);
    }

    @Override
    public Class<CommonDesignTemplates> getTypeClass() {
        return CommonDesignTemplates.class;
    }

    @Override
    public void onChangesApplied(DesignTemplatesOperationContainer updateContainer,
                                 List<AppliedChanges<CommonDesignTemplates>> appliedChanges) {
        for (AppliedChanges<CommonDesignTemplates> appliedChange : appliedChanges) {
            Map<String, Object> designSettings =
                    appliedChange.getNewValue(CommonDesignTemplates.DESIGN_SETTINGS);
            if (designSettings == null) {
                continue;
            }
            appliedChange.modify(
                    CommonDesignTemplates.DESIGN_SETTINGS,
                    DesignSettingsHelper.getFixedSettings(designSettings)
            );
        }
    }
}
