package ru.yandex.partner.core.entity.designtemplates.type.common;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class DesignSettingsHelper {
    private static final Set<String> NUMBER_DESIGN_SETTINGS = Set.of(
            "limit", "fontSize"
    );

    private DesignSettingsHelper() {
        // utility
    }

    public static Map<String, Object> getFixedSettings(Map<String, Object> designSettings) {
        HashMap<String, Object> newDesignSettings = new HashMap<>(designSettings);
        for (String numberDesignSetting : NUMBER_DESIGN_SETTINGS) {
            newDesignSettings.computeIfPresent(
                    numberDesignSetting,
                    (k, v) -> v instanceof String ? new BigDecimal((String) v).stripTrailingZeros() : v
            );
        }
        return newDesignSettings;
    }
}
