package ru.yandex.partner.core.entity.domain.filter;

import ru.yandex.partner.core.entity.domain.model.BaseDomain;
import ru.yandex.partner.core.filter.FilterType;
import ru.yandex.partner.core.filter.dbmeta.NumberFilter;
import ru.yandex.partner.core.filter.meta.MetaFilter;
import ru.yandex.partner.core.filter.meta.StringMetaFilter;

import static ru.yandex.partner.dbschema.partner.Tables.MOBILE_APP;

public class DomainFilters {
    public static final StringMetaFilter<BaseDomain> DOMAIN = new StringMetaFilter<>("domain", BaseDomain.class);

    public static final NumberFilter<BaseDomain, Long> TYPE = new NumberFilter<>(
            "type", FilterType.DICTIONARY, BaseDomain.class, MOBILE_APP.TYPE
    );

    public static final MetaFilter<BaseDomain, Long> ID = new NumberFilter<>("id", BaseDomain.class,
        MOBILE_APP.ID);

    private DomainFilters() {
    }
}
