package ru.yandex.partner.core.entity.domain.filter;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.domain.model.BaseDomain;
import ru.yandex.partner.core.filter.container.CommonModelFilterContainer;
import ru.yandex.partner.core.filter.db.StringDbFilter;
import ru.yandex.partner.dbschema.partner.tables.Site;

@Component
public class DomainModelFilterContainer extends CommonModelFilterContainer<BaseDomain> {

    @Autowired
    public DomainModelFilterContainer() {
        super(List.of(new StringDbFilter<>(DomainFilters.DOMAIN, BaseDomain.class, Site.SITE.DOMAIN)));
    }

    @Override
    public Class<BaseDomain> getModelClass() {
        return BaseDomain.class;
    }
}
