package ru.yandex.partner.core.entity.domain.filter;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.domain.model.BaseDomain;
import ru.yandex.partner.core.filter.container.CommonModelFilterContainer;
import ru.yandex.partner.core.filter.db.StringDbFilter;
import ru.yandex.partner.dbschema.partner.tables.InternalSite;

@Component
public class InternalDomainModelFilterContainer extends CommonModelFilterContainer<BaseDomain> {

    @Autowired
    public InternalDomainModelFilterContainer() {
        super(List.of(new StringDbFilter<>(DomainFilters.DOMAIN, BaseDomain.class,
                InternalSite.INTERNAL_SITE.DOMAIN)));
    }

    @Override
    public Class<BaseDomain> getModelClass() {
        return BaseDomain.class;
    }
}
