package ru.yandex.partner.core.entity.dsp

import org.springframework.context.annotation.Bean
import org.springframework.context.annotation.Configuration
import ru.yandex.direct.multitype.typesupport.TypeSupportAffectionHelper
import ru.yandex.partner.core.entity.common.editablefields.EditableFieldsService
import ru.yandex.partner.core.entity.dsp.model.BaseDsp
import ru.yandex.partner.core.entity.dsp.repository.type.DspRepositoryTypeSupportFacade

@Configuration
class DspConfiguration {

    @Bean
    fun dspTypeSupportAffectionHelper(): TypeSupportAffectionHelper<BaseDsp> {
        return TypeSupportAffectionHelper<BaseDsp>(emptySet())
    }

    @Bean
    fun dspEditableFieldsService(
        facade: DspRepositoryTypeSupportFacade,
        helper: TypeSupportAffectionHelper<BaseDsp>): EditableFieldsService<BaseDsp> {
        return EditableFieldsService<BaseDsp>(facade, helper)
    }

}
