package ru.yandex.partner.core.entity.dsp.actions;

import ru.yandex.partner.libs.multistate.action.ActionNameHolder;

public enum DspActionsEnum implements ActionNameHolder {
    CREATE_IN_BK("create_in_bk"),
    CREATE_IN_PI("create_in_pi"),
    LINK_IN_BALANCE("link_in_balance"),
    START("start"),
    STOP("stop"),
    REQUEST_FOR_APPROVAL("request_for_approval"),
    APPROVE("approve"),
    EDIT("edit"),
    START_ON_ALL_PLATFORMS("start_on_all_platforms"),
    STOP_ON_ALL_PLATFORMS("stop_on_all_platforms"),
    START_ON_YANDEX_SERVICES("start_on_yandex_services"),
    STOP_ON_YANDEX_SERVICES("stop_on_yandex_services"),
    TEST("test"),
    ADD("add"),
    DELETE("delete"),
    RESTORE("restore"),
    SET_FLAG_NEED_CREATE_IN_PI("set_flag_need_create_in_pi"),
    SET_FLAG_NOT_NEED_CREATE_IN_PI("set_flag_not_need_create_in_pi"),
    RESEND_TO_BK("resend_to_bk");

    private final String actionName;

    DspActionsEnum(String actionName) {
        this.actionName = actionName;
    }

    @Override
    public String getActionName() {
        return actionName;
    }
}
