package ru.yandex.partner.core.entity.dsp.container;

import java.util.HashSet;
import java.util.Set;

import org.jetbrains.annotations.NotNull;

import ru.yandex.partner.core.entity.dsp.model.BaseDsp;
import ru.yandex.partner.core.entity.dsp.model.Dsp;

public class DspContainerImpl implements DspContainer {

    private Set<Long> modelIds;

    private DspContainerImpl() {
        modelIds = new HashSet<>();
    }

    public static DspContainerImpl create() {
        return new DspContainerImpl();
    }

    @Override
    public Set<Long> getModelIds() {
        return modelIds;
    }

    @Override
    public void setModelIds(Set<Long> modelIds) {
        this.modelIds = new HashSet<>(modelIds);
    }

    @Override
    public int getShard() {
        return 0;
    }

    @Override
    public Class<? extends BaseDsp> getRuntimeClass(@NotNull Long modelId) {
        return Dsp.class;
    }
}
