package ru.yandex.partner.core.entity.dsp.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.Table;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.partner.core.configuration.DslContextProviderStub;
import ru.yandex.partner.core.entity.PageBlockIds;
import ru.yandex.partner.core.entity.dsp.container.DspRepositoryContainer;
import ru.yandex.partner.core.entity.dsp.model.BaseDsp;
import ru.yandex.partner.core.entity.dsp.repository.type.DspRepositoryTypeSupportFacade;
import ru.yandex.partner.core.entity.utils.ConditionUtils;
import ru.yandex.partner.core.multitype.repository.PartnerModifyRepository;
import ru.yandex.partner.core.multitype.repository.relation.Id;
import ru.yandex.partner.core.service.dbutil.DbValuesGenerator;
import ru.yandex.partner.dbschema.partner.tables.BlockDsps;
import ru.yandex.partner.dbschema.partner.tables.records.BlockDspsRecord;
import ru.yandex.partner.dbschema.partner.tables.records.BlockDspsUnmoderatedRecord;
import ru.yandex.partner.libs.utils.JooqUtils;

import static ru.yandex.partner.dbschema.partner.Tables.BLOCK_DSPS_UNMODERATED;
import static ru.yandex.partner.dbschema.partner.tables.BlockDsps.BLOCK_DSPS;

@Repository
@ParametersAreNonnullByDefault
public class DspModifyRepository extends PartnerModifyRepository<BaseDsp, BaseDsp, DspRepositoryContainer,
        DspRepositoryContainer> {
    // TODO: Заменить директовский dbValuesGenerator на генератор на основе *_block_seq
    private final DbValuesGenerator dbValuesGenerator;

    @Autowired
    public DspModifyRepository(DSLContext dslContext, DspRepositoryTypeSupportFacade typeSupportFacade,
                               DspTypedRepository typedRepository,
                               DbValuesGenerator dbValuesGenerator) {
        super(
                new DslContextProviderStub(dslContext),
                typeSupportFacade,
                typedRepository,
                Id.column(BLOCK_DSPS.BLOCK_ID)
        );
        this.dbValuesGenerator = dbValuesGenerator;
    }

    @Override
    protected void generateIds(DspRepositoryContainer addContainer, List<? extends BaseDsp> models) {
        // TODO: Исправить на правильную реализацию с использованием *_block_seq
//        Iterator<Long> blockIds = longValues(
//                dbValuesGenerator.generateValues(
//                        USERS,
//                        USERS.ID,
//                        mapList(models, ModelWithId::getId))
//        ).iterator();
//        models.forEach(user -> user.setId(blockIds.next()));
    }

    @Override
    protected Table<?> getLockTable() {
        return BLOCK_DSPS;
    }

    public void deleteBlockDsps(DSLContext dslContext, Collection<PageBlockIds> pageBlockIds) {
        dslContext.deleteFrom(BlockDsps.BLOCK_DSPS)
                .where(
                        ConditionUtils.toPageBlockCondition(pageBlockIds, BLOCK_DSPS.PAGE_ID, BLOCK_DSPS.BLOCK_ID)
                        // .and(BLOCK_DSPS.IS_DELETED.eq(0L))
                )
                .execute();
    }

    public <T extends BaseDsp> void addBlockDsps(DSLContext dslContext, Map<PageBlockIds, List<T>> blockDsps) {
        var records = blockDsps.entrySet()
                .stream()
                .flatMap(entry -> entry.getValue().stream().map(dsp -> new BlockDspsRecord(
                        entry.getKey().getPageId(),
                        entry.getKey().getBlockId(),
                        dsp.getId(),
                        null,
                        null,
                        0L
                )))
                .collect(Collectors.toList());

        JooqUtils.insertRecords(dslContext, BLOCK_DSPS, records);
    }

    public void deleteBlockDspsUnmoderated(DSLContext dslContext, List<PageBlockIds> pageBlockIds) {
        dslContext.deleteFrom(BLOCK_DSPS_UNMODERATED)
                .where(
                        ConditionUtils.toPageBlockCondition(pageBlockIds, BLOCK_DSPS_UNMODERATED.PAGE_ID,
                                BLOCK_DSPS_UNMODERATED.BLOCK_ID)
                )
                .execute();
    }

    public void addBlockDspsUnmoderated(DSLContext dslContext, Map<PageBlockIds, List<Long>> newDsps) {
        var records = newDsps.entrySet()
                .stream()
                .flatMap(entry -> entry.getValue().stream().map(dspId -> new BlockDspsUnmoderatedRecord(
                        entry.getKey().getPageId(),
                        entry.getKey().getBlockId(),
                        dspId
                )))
                .collect(Collectors.toList());

        JooqUtils.insertRecords(dslContext, BLOCK_DSPS_UNMODERATED, records);
    }
}
