package ru.yandex.partner.core.entity.dsp.repository.type;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.dsp.container.DspRepositoryContainer;
import ru.yandex.partner.core.entity.dsp.model.BaseDsp;
import ru.yandex.partner.core.entity.dsp.model.Dsp;
import ru.yandex.partner.core.multitype.repository.PartnerRepositoryTypeSupportFacade;

@Component
@ParametersAreNonnullByDefault
public class DspRepositoryTypeSupportFacade extends PartnerRepositoryTypeSupportFacade<BaseDsp, Long,
        DspRepositoryContainer, DspRepositoryContainer> {
    @Autowired
    public DspRepositoryTypeSupportFacade(List<DspRepositoryTypeSupport<? extends BaseDsp>> typeSupports) {
        super(typeSupports, Dsp::new, Set.of(BaseDsp.class));
    }

    @Override
    protected Long getModelType(Record record) {
        return 0L;
    }

}
