package ru.yandex.partner.core.entity.dsp.rules;

import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.dsp.model.BaseDsp;
import ru.yandex.partner.core.entity.dsp.rules.result.DspRuleResult;
import ru.yandex.partner.core.entity.page.model.BasePage;

public abstract class DspRule<P extends BasePage, B extends BaseBlock, D extends BaseDsp> {
    public DspRuleResult availableDsps(DspRuleContainer dspRuleContainer, B block) {
        return null;
    }

    public DspRuleResult defaultDsps(DspRuleContainer dspRuleContainer, P page, B block) {
        return null;
    }

    public DspRuleResult turnOnDsps(DspRuleContainer dspRuleContainer, P page, B block, D dsp) {
        return null;
    }

    public ValidationResult<B, Defect> dspsFieldValidation(DspRuleContainer dspRuleContainer,
                                                           BlockContainer container,
                                                           ValidationResult<B, Defect> vr) {
        return vr;
    }

    public void dspsFieldEdit(
            DspRuleContainer dspRuleContainer,
            AppliedChanges<B> modelChanges) {
    }
}
