package ru.yandex.partner.core.entity.dsp.rules;

import javax.annotation.Nullable;

import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.dsp.rules.result.DspRuleResult;
import ru.yandex.partner.core.entity.dsp.rules.result.DspRuleResultType;
import ru.yandex.partner.core.entity.page.model.BasePage;

public class DspRuleUtils {
    private DspRuleUtils() {

    }

    @SuppressWarnings("unchecked")
    public static DspRuleResult buildAvailableDspsFilter(
            DspRuleContainer dspRuleContainer, BaseBlock block, DspRuleSet ruleSet) {
        return buildDspsFilter(dspRuleContainer, null, block, ruleSet, (r, c, p, b) -> r.availableDsps(c, b));
    }

    @SuppressWarnings("unchecked")
    public static DspRuleResult buildDefaultDspsFilter(
            DspRuleContainer dspRuleContainer, @Nullable BasePage page, BaseBlock block, DspRuleSet ruleSet) {
        return buildDspsFilter(dspRuleContainer, page, block, ruleSet, DspRule::defaultDsps);
    }

    public static DspRuleResult buildDspsFilter(
            DspRuleContainer dspRuleContainer,
            @Nullable BasePage page,
            BaseBlock block,
            DspRuleSet ruleSet,
            DspsGetter function) {
        var extendFilter = DspRuleResult.extendZero();
        var limitFilter = DspRuleResult.limitIdentity();
        for (var rule : ruleSet.getRules()) {
            DspRuleResult ruleResult = function.getDsps(rule, dspRuleContainer, page, block);
            if (ruleResult == null) {
                continue;
            }
            switch (ruleResult.getType()) {
                case EXTEND:
                case EXTEND_IDENTITY:
                case EXTEND_ZERO:
                    extendFilter = extendFilter.or(ruleResult);
                    break;
                case LIMIT:
                case LIMIT_IDENTITY:
                case LIMIT_ZERO:
                    limitFilter = limitFilter.and(ruleResult);
                    break;
                default:
                    throw new IllegalArgumentException("Illegal DspRuleResultType.");
            }
        }
        if (extendFilter.getType() == DspRuleResultType.EXTEND) {
            if (limitFilter.getType() == DspRuleResultType.LIMIT_IDENTITY) {
                limitFilter = DspRuleResult.limit(extendFilter.getInnerCondition());
            } else if (limitFilter.getType() == DspRuleResultType.LIMIT) {
                limitFilter = DspRuleResult.limit(
                        limitFilter.getInnerCondition().and(extendFilter.getInnerCondition()));
            }
        }
        return limitFilter;
    }
}
