package ru.yandex.partner.core.entity.dsp.rules.result;

import java.util.Objects;

import org.jooq.Condition;

public class DspRuleResult {
    private final DspRuleResultType type;
    private final Condition innerCondition;

    public DspRuleResult(DspRuleResultType type, Condition innerCondition) {
        this.type = type;
        this.innerCondition = innerCondition;
    }

    public DspRuleResultType getType() {
        return type;
    }

    public Condition getInnerCondition() {
        return innerCondition;
    }

    public static DspRuleResult extend(Condition condition) {
        return new DspRuleResult(DspRuleResultType.EXTEND, condition);
    }

    public static DspRuleResult extendZero() {
        return new DspRuleResult(DspRuleResultType.EXTEND_ZERO, null);
    }

    public static DspRuleResult extendIdentity() {
        return new DspRuleResult(DspRuleResultType.EXTEND_IDENTITY, null);
    }

    public static DspRuleResult limit(Condition condition) {
        return new DspRuleResult(DspRuleResultType.LIMIT, condition);
    }

    public static DspRuleResult limitZero() {
        return new DspRuleResult(DspRuleResultType.LIMIT_ZERO, null);
    }

    public static DspRuleResult limitIdentity() {
        return new DspRuleResult(DspRuleResultType.LIMIT_IDENTITY, null);
    }

    public DspRuleResult or(DspRuleResult newResult) {
        if (Objects.equals(this.getType(), DspRuleResultType.EXTEND_IDENTITY) ||
                Objects.equals(newResult.getType(), DspRuleResultType.EXTEND_ZERO)) {
            return this;
        }
        if (Objects.equals(this.getType(), DspRuleResultType.EXTEND_ZERO) ||
                Objects.equals(newResult.getType(), DspRuleResultType.EXTEND_IDENTITY)) {
            return newResult;
        }
        if (Objects.equals(newResult.getType(), DspRuleResultType.EXTEND)) {
            return DspRuleResult.extend(this.getInnerCondition().or(newResult.getInnerCondition()));
        }
        throw new IllegalArgumentException("Illegal DspRuleResultType. Must be one of EXTEND");
    }

    public DspRuleResult and(DspRuleResult newResult) {
        if (Objects.equals(this.getType(), DspRuleResultType.LIMIT_ZERO) ||
                Objects.equals(newResult.getType(), DspRuleResultType.LIMIT_IDENTITY)) {
            return this;
        }
        if (Objects.equals(this.getType(), DspRuleResultType.LIMIT_IDENTITY) ||
                Objects.equals(newResult.getType(), DspRuleResultType.LIMIT_ZERO)) {
            return newResult;
        }
        if (Objects.equals(newResult.getType(), DspRuleResultType.LIMIT)) {
            return DspRuleResult.limit(this.getInnerCondition().and(newResult.getInnerCondition()));
        }
        throw new IllegalArgumentException("Illegal DspRuleResultType. Must be one of LIMIT");
    }
}
