package ru.yandex.partner.core.entity.dsp.service;

import java.util.List;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.entity.dsp.container.DspContainer;
import ru.yandex.partner.core.entity.dsp.container.DspContainerImpl;
import ru.yandex.partner.core.entity.dsp.model.BaseDsp;
import ru.yandex.partner.core.entity.dsp.service.validation.type.DspValidationTypeSupportFacade;

@Service
public class DspValidationService {
    private final DspValidationTypeSupportFacade validationFacade;

    @Autowired
    public DspValidationService(DspValidationTypeSupportFacade validationFacade) {
        this.validationFacade = validationFacade;
    }

    /**
     * Метод принудительно наполняет контейнер данными (словарей и пр.), которые необходимы для валидации
     * В обычном режиме данные подтягиваются перед вызовом метода validate конкретного support'а в фасаде
     *
     * @param container - контейнер с общими данными
     */
    public void forceFillContainerByValidationSupports(DspContainer container) {
        // Вызываем принудительную наливку данных всеми typesupport'ами
        validationFacade.forceFillContainerByValidationSupports(container);
    }

    public ValidationResult<List<? extends BaseDsp>, Defect> validate(List<? extends BaseDsp> models) {
        return validate(models, DspContainerImpl.create());
    }

    public ValidationResult<List<? extends BaseDsp>, Defect> validate(
            List<? extends BaseDsp> models, DspContainer container) {
        // Заполняем контейнер ID пользователей
        container.setModelIds(models.stream()
                .map(BaseDsp::getId)
                .collect(Collectors.toSet()));

        ValidationResult<List<? extends BaseDsp>, Defect> vr = new ValidationResult<>(models);
        validationFacade.validate(container, vr);
        return vr;
    }
}
