package ru.yandex.partner.core.entity.dsp.service.validation.type;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.partner.core.entity.dsp.container.DspContainer;
import ru.yandex.partner.core.entity.dsp.model.BaseDsp;
import ru.yandex.partner.core.multitype.service.validation.type.AbstractValidationTypeSupport;

@ParametersAreNonnullByDefault
public abstract class AbstractDspValidationTypeSupport<B extends BaseDsp>
        extends AbstractValidationTypeSupport<B, DspContainer>
        implements DspValidationTypeSupport<B> {

    private final Class<B> typeClass;

    public AbstractDspValidationTypeSupport(Class<B> typeClass) {
        this.typeClass = typeClass;
    }

    @Override
    public Class<B> getTypeClass() {
        return typeClass;
    }
}
