package ru.yandex.partner.core.entity.dsp.service.validation.type;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.multitype.typesupport.TypeSupportAffectionHelper;
import ru.yandex.partner.core.entity.dsp.container.DspContainer;
import ru.yandex.partner.core.entity.dsp.container.DspContainerImpl;
import ru.yandex.partner.core.entity.dsp.container.DspRepositoryContainer;
import ru.yandex.partner.core.entity.dsp.model.BaseDsp;
import ru.yandex.partner.core.entity.dsp.repository.type.DspRepositoryTypeSupport;
import ru.yandex.partner.core.multitype.service.validation.type.ValidationTypeSupportFacade;

@Component
@ParametersAreNonnullByDefault
public class DspValidationTypeSupportFacade
        extends ValidationTypeSupportFacade<BaseDsp, DspContainer, DspRepositoryContainer> {

    @Autowired
    public DspValidationTypeSupportFacade(List<DspValidationTypeSupport<? extends BaseDsp>> supports,
                                          List<DspRepositoryTypeSupport<? extends BaseDsp>> typeSupports,
                                          TypeSupportAffectionHelper<BaseDsp> typeSupportAffectionHelper) {
        super(supports, typeSupports, typeSupportAffectionHelper, DspContainerImpl::create);
    }
}
