package ru.yandex.partner.core.entity.dsp.type.common;

import java.util.HashSet;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.Sets;
import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.partner.core.entity.dsp.model.DspWithCommonFields;
import ru.yandex.partner.core.entity.dsp.repository.type.AbstractDspRepositoryTypeSupport;
import ru.yandex.partner.core.entity.dsp.repository.type.DspRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.holder.ModelPropertiesHolder;
import ru.yandex.partner.core.multistate.AbstractMultistate;
import ru.yandex.partner.core.multistate.dsp.DspMultistate;
import ru.yandex.partner.core.multistate.dsp.DspStateFlag;
import ru.yandex.partner.core.operation.CoreModelProvider;
import ru.yandex.partner.core.props.CoreModel;
import ru.yandex.partner.core.props.ModelPropertyDefault;
import ru.yandex.partner.core.utils.CommonConverters;

import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;
import static ru.yandex.partner.core.entity.dsp.DspConstants.EDIT_FORBIDDEN_MODEL_PROPERTIES;
import static ru.yandex.partner.core.entity.dsp.model.prop.BaseDspIdPropHolder.ID;
import static ru.yandex.partner.core.entity.dsp.model.prop.BaseDspPublicIdPropHolder.PUBLIC_ID;
import static ru.yandex.partner.core.entity.dsp.model.prop.DspWithCommonFieldsDataKeyPropHolder.DATA_KEY;
import static ru.yandex.partner.core.entity.dsp.model.prop.DspWithCommonFieldsDisplayNamePropHolder.DISPLAY_NAME;
import static ru.yandex.partner.core.entity.dsp.model.prop.DspWithCommonFieldsIsCreatedInBkPropHolder.IS_CREATED_IN_BK;
import static ru.yandex.partner.core.entity.dsp.model.prop.DspWithCommonFieldsIsDeletedPropHolder.IS_DELETED;
import static ru.yandex.partner.core.entity.dsp.model.prop.DspWithCommonFieldsPostmoderatedPropHolder.POSTMODERATED;
import static ru.yandex.partner.core.entity.dsp.model.prop.DspWithCommonFieldsShortCaptionPropHolder.SHORT_CAPTION;
import static ru.yandex.partner.core.entity.dsp.model.prop.DspWithCommonFieldsShowProbabilityPropHolder.SHOW_PROBABILITY;
import static ru.yandex.partner.core.entity.dsp.model.prop.DspWithCommonFieldsSkipnoudPropHolder.SKIPNOUD;
import static ru.yandex.partner.core.entity.dsp.model.prop.DspWithCommonFieldsTagPropHolder.TAG;
import static ru.yandex.partner.core.entity.dsp.model.prop.DspWithCommonFieldsTestUrlPropHolder.TEST_URL;
import static ru.yandex.partner.core.entity.dsp.model.prop.DspWithCommonFieldsUnmoderatedRtbAuctionPropHolder.UNMODERATED_RTB_AUCTION;
import static ru.yandex.partner.core.entity.dsp.model.prop.DspWithCommonFieldsUrlPropHolder.URL;
import static ru.yandex.partner.core.entity.dsp.model.prop.DspWithMultistateMultistatePropHolder.MULTISTATE;
import static ru.yandex.partner.core.holder.ModelPropertiesHolder.fromModelProperties;
import static ru.yandex.partner.dbschema.partner.Tables.DSP;

@Component
@ParametersAreNonnullByDefault
public class DspWithCommonFieldsRepositoryTypeSupport
        extends AbstractDspRepositoryTypeSupport<DspWithCommonFields>
        implements DspRepositoryTypeSupportWithMapper<DspWithCommonFields>,
        CoreModelProvider<DspWithCommonFields> {
    private static final CoreModel<DspWithCommonFields> DEFAULT_VALUES = CoreModel.forClass(
                    DspWithCommonFields.class)
            .property(ModelPropertyDefault.<DspWithCommonFields, String>forProperty(DATA_KEY)
                    .optional().withDefaultValue(""))
            .property(ModelPropertyDefault.<DspWithCommonFields, Long>forProperty(SHOW_PROBABILITY)
                    .optional().withDefaultValue(100L))
            .build();
    private final JooqMapper<DspWithCommonFields> mapper;

    @Autowired
    protected DspWithCommonFieldsRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext);
        this.mapper = createCommonDspMapper();
    }

    private static JooqMapper<DspWithCommonFields> createCommonDspMapper() {
        return JooqMapperBuilder.<DspWithCommonFields>builder()
                .map(property(ID, DSP.ID))
                .readProperty(PUBLIC_ID, fromField(DSP.ID).by(v -> v))
                .map(convertibleProperty(MULTISTATE, DSP.MULTISTATE,
                        DspMultistate::new, AbstractMultistate::toMultistateValue))
                .map(property(SHORT_CAPTION, DSP.SHORT_CAPTION))
                .map(property(DISPLAY_NAME, DSP.DISPLAY_NAME))
                .map(property(URL, DSP.URL))
                .map(property(TEST_URL, DSP.TEST_URL))
                .map(convertibleProperty(SKIPNOUD, DSP.SKIPNOUD,
                        CommonConverters::booleanFromLong, CommonConverters::booleanToLong))
                .map(property(TAG, DSP.TAG))
                .map(property(DATA_KEY, DSP.DATA_KEY))
                .map(property(SHOW_PROBABILITY, DSP.SHOW_PROBABILITY))
                .map(convertibleProperty(POSTMODERATED, DSP.POSTMODERATED,
                        CommonConverters::booleanFromLong, CommonConverters::booleanToLong))
                .map(convertibleProperty(UNMODERATED_RTB_AUCTION, DSP.UNMODERATED_RTB_AUCTION,
                        CommonConverters::booleanFromLong, CommonConverters::booleanToLong))
                .readProperty(IS_DELETED,
                        fromField(DSP.MULTISTATE).by(m -> new DspMultistate(m).test(DspStateFlag.DELETED)))
                .readProperty(IS_CREATED_IN_BK,
                        fromField(DSP.MULTISTATE).by(m -> new DspMultistate(m).test(DspStateFlag.CREATED_IN_BK)))
                .build();
    }

    @Override
    public JooqMapper<DspWithCommonFields> getJooqMapper() {
        return mapper;
    }

    @Override
    public Class<DspWithCommonFields> getTypeClass() {
        return DspWithCommonFields.class;
    }

    @Override
    public ModelPropertiesHolder getEditableModelProperties(
            DspWithCommonFields model) {
        return fromModelProperties(
                new HashSet<>(
                        Sets.difference(getJooqMapper().getWritableModelProperties(), EDIT_FORBIDDEN_MODEL_PROPERTIES)
                )
        );
    }

    @Override
    public CoreModel<DspWithCommonFields> getCoreModel() {
        return DEFAULT_VALUES;
    }
}
