package ru.yandex.partner.core.entity.dsp.type.common;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.entity.dsp.container.DspContainer;
import ru.yandex.partner.core.entity.dsp.model.DspWithCommonFields;
import ru.yandex.partner.core.entity.dsp.service.validation.type.AbstractDspValidationTypeSupport;

@Component
public class DspWithCommonFieldsValidateTypeSupport
        extends AbstractDspValidationTypeSupport<DspWithCommonFields> {
    private final DspWithCommonFieldsValidatorProvider validatorProvider;

    public DspWithCommonFieldsValidateTypeSupport(DspWithCommonFieldsValidatorProvider validatorProvider) {
        super(DspWithCommonFields.class);
        this.validatorProvider = validatorProvider;
    }

    @Override
    public ValidationResult<List<DspWithCommonFields>, Defect> validate(
            DspContainer container,
            ValidationResult<List<DspWithCommonFields>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.dspWithCommonFieldsValidator())
                .getResult();
    }
}
