package ru.yandex.partner.core.entity.dsp.type.common;

import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;
import ru.yandex.partner.core.entity.dsp.model.BaseDsp;
import ru.yandex.partner.core.entity.dsp.model.DspWithCommonFields;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.constraint.NumberConstraints.inRange;
import static ru.yandex.direct.validation.constraint.StringConstraints.maxStringLength;

@Component
public class DspWithCommonFieldsValidatorProvider {
    public Validator<DspWithCommonFields, Defect> dspWithCommonFieldsValidator() {
        return dsp -> {
            ModelItemValidationBuilder<DspWithCommonFields> vb = ModelItemValidationBuilder.of(dsp);
            vb.item(BaseDsp.ID).check(notNull());
            vb.item(BaseDsp.PUBLIC_ID)
                    .check(notNull());
//                    .check(isEqual(dsp.getId()));
            vb.item(DspWithCommonFields.MULTISTATE)
                    .check(notNull());

            vb.item(DspWithCommonFields.SHORT_CAPTION)
                    .check(notNull())
                    .check(maxStringLength(32));
            vb.item(DspWithCommonFields.DISPLAY_NAME)
                    .check(maxStringLength(32), When.notNull());
            vb.item(DspWithCommonFields.URL)
                    .check(notNull())
                    .check(maxStringLength(1024));
            vb.item(DspWithCommonFields.TEST_URL)
                    .check(notNull())
                    .check(maxStringLength(1024));
            vb.item(DspWithCommonFields.TAG)
                    .check(maxStringLength(32), When.notNull());
            vb.item(DspWithCommonFields.DATA_KEY)
                    .check(notNull())
                    .check(maxStringLength(255));
            vb.item(DspWithCommonFields.SHOW_PROBABILITY)
                    .check(notNull())
                    .check(inRange(0L, 100L));

            return vb.getResult();
        };
    }
}
