package ru.yandex.partner.core.entity.dsp.type.formats;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.dsp.model.BaseDsp;
import ru.yandex.partner.core.entity.dsp.model.DspWithFormats;
import ru.yandex.partner.core.entity.dsp.repository.type.AbstractDspRepositoryTypeSupport;
import ru.yandex.partner.core.entity.dsp.repository.type.DspRepositoryTypeSupportWithoutMapper;

import static ru.yandex.partner.dbschema.partner.Tables.DSP_FORMAT;

@Component
@ParametersAreNonnullByDefault
public class DspWithFormatsRepositoryTypeSupport extends AbstractDspRepositoryTypeSupport<DspWithFormats>
        implements DspRepositoryTypeSupportWithoutMapper<DspWithFormats> {
    private final Set<ModelProperty<? super DspWithFormats, ?>> affectedModelProperties;

    @Autowired
    public DspWithFormatsRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext);
        affectedModelProperties = Set.of(DspWithFormats.FORMATS);
    }

    @Override
    public Set<ModelProperty<? super DspWithFormats, ?>> getAffectedModelProperties() {
        return affectedModelProperties;
    }

    @Override
    public Class<DspWithFormats> getTypeClass() {
        return DspWithFormats.class;
    }

    @Override
    public void enrichModelFromOtherTables(DSLContext dslContext, Collection<DspWithFormats> models) {
        Set<Long> modelIds = models.stream()
                .map(BaseDsp::getId)
                .collect(Collectors.toSet());

        Map<Long, List<Long>> selectedDspFormats = dslContext.select(DSP_FORMAT.DSP_ID, DSP_FORMAT.FORMAT_ID)
                .from(DSP_FORMAT)
                .where(DSP_FORMAT.DSP_ID.in(modelIds))
                .fetchGroups(DSP_FORMAT.DSP_ID, DSP_FORMAT.FORMAT_ID);

        for (DspWithFormats dsp : models) {
            List<Long> dspFormats = selectedDspFormats.getOrDefault(dsp.getId(), List.of());
            dsp.setFormats(dspFormats);
        }
    }
}
