package ru.yandex.partner.core.entity.geo;

import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.TableField;
import org.springframework.stereotype.Repository;

import ru.yandex.partner.core.entity.DictRepository;
import ru.yandex.partner.dbschema.partner.tables.GeoBase;
import ru.yandex.partner.dbschema.partner.tables.records.GeoBaseRecord;

import static ru.yandex.partner.dbschema.partner.tables.GeoBase.GEO_BASE;

@Repository
@ParametersAreNonnullByDefault
public class GeoBaseRepository extends DictRepository<GeoBaseRecord> {

    private final DSLContext dslContext;

    public GeoBaseRepository(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    @Override
    @Nonnull
    protected GeoBase getTable() {
        return GEO_BASE;
    }

    @Override
    @Nonnull
    protected TableField<GeoBaseRecord, Long> getIdField() {
        return getTable().ID;
    }

    public List<GeoBaseDto> getRawGeoBase() {
        return dslContext.selectFrom(GEO_BASE)
                .fetch()
                .stream()
                .map(record -> new GeoBaseDto(record.getId(), record.getParentId(),
                        record.getRegularity(), record.getLevel()))
                .collect(Collectors.toList());
    }
}
