package ru.yandex.partner.core.entity.geo;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

import org.springframework.stereotype.Service;

import ru.yandex.partner.core.CoreConstants;
import ru.yandex.partner.core.entity.block.model.Geo;

import static java.util.Collections.reverseOrder;

@Service
public class GeoService {
    private static final Comparator<GeoBaseDto> GEO_ORDER = Comparator.comparingLong(GeoBaseDto::getLevel)
            .thenComparing(GeoBaseDto::getRegularity, reverseOrder())
            .thenComparingLong(GeoBaseDto::getId);

    public List<GeoBaseDto> getDtosWithFilledCrimea(boolean isCrimeaRussian, List<GeoBaseDto> geoBaseDtos) {
        List<GeoBaseDto> result = new ArrayList<>(geoBaseDtos);

        long crimeaLevel = isCrimeaRussian ? 2L : 3L;
        long crimeaParentId = isCrimeaRussian ? 26L : 20526L;

        for (int i = 0; i < geoBaseDtos.size(); i++) {
            if (geoBaseDtos.get(i).getId() == CoreConstants.CRIMEA_ID) {
                var oldDto = geoBaseDtos.get(i);
                result.set(i, new GeoBaseDto(
                        oldDto.getId(), crimeaParentId,
                        oldDto.getRegularity(), crimeaLevel));
            }
        }

        result.sort(GEO_ORDER);

        return result;
    }

    public List<Geo> getSubtreesWithRootsCpm(List<Geo> subtreeRoots, List<GeoBaseDto> geoBaseDtos) {
        Map<Long, BigDecimal> cpm = subtreeRoots.stream()
                .collect(Collectors.toMap(Geo::getId, Geo::getCpm));

        List<Geo> result = new ArrayList<>();

        for (var geoBaseDto : geoBaseDtos) {
            Optional<Long> optParentId = Optional.ofNullable(geoBaseDto.getParentId());
            Long id = geoBaseDto.getId();

            if (optParentId.isPresent()) {
                Long parentId = optParentId.get();
                if (cpm.containsKey(parentId) && !cpm.containsKey(id)) {
                    cpm.put(id, cpm.get(parentId));
                }
            }

            if (cpm.containsKey(id)) {
                result.add(new Geo().withId(id)
                        .withCpm(cpm.get(id))
                );
            }
        }

        return result;
    }
}
