package ru.yandex.partner.core.entity.mirror;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.mirror.actions.MirrorActionsEnum;
import ru.yandex.partner.core.entity.mirror.model.BaseMirror;
import ru.yandex.partner.core.messages.MirrorStateMsg;
import ru.yandex.partner.core.multistate.Multistate;
import ru.yandex.partner.core.multistate.mirror.MirrorMultistate;
import ru.yandex.partner.core.multistate.mirror.MirrorStateFlag;
import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.multistate.action.ActionEntry;
import ru.yandex.partner.libs.multistate.action.ActionNameHolder;
import ru.yandex.partner.libs.multistate.graph.AbstractMultistateGraph;

import static ru.yandex.partner.libs.multistate.MultistatePredicates.empty;

@Component
public class MirrorMultistateGraph extends AbstractMultistateGraph<BaseMirror, MirrorStateFlag> {

    @Override
    public Multistate<MirrorStateFlag> getMultistateFromModel(BaseMirror model) {
        return model.getMultistate();
    }

    @Override
    protected Map<ActionNameHolder, ActionEntry<BaseMirror, MirrorStateFlag>> createGraph() {

        // TODO заглушка экшенов, что бы завелся метод
        //  Set<Multistate<T>> getMultsitatesForPredicate(Predicate<Multistate<T>> predicate)
        Map<ActionNameHolder, ActionEntry<BaseMirror, MirrorStateFlag>> actionEntryMap = new HashMap<>();

        actionEntryMap.put(
                MirrorActionsEnum.DUMMY1,
                getActionEntryBuilder(MirrorStateMsg.APPROVED)
                        .setPredicate(empty())
                        .setSetFlags(Map.of(
                                MirrorStateFlag.APPROVED, true
                        ))
                        .build());

        actionEntryMap.put(
                MirrorActionsEnum.DUMMY2,
                getActionEntryBuilder(MirrorStateMsg.REJECTED)
                        .setPredicate(empty())
                        .setSetFlags(Map.of(
                                MirrorStateFlag.REJECTED, true
                        ))
                        .build());

        actionEntryMap.put(
                MirrorActionsEnum.DUMMY3,
                getActionEntryBuilder(MirrorStateMsg.DELETED)
                        .setPredicate(empty())
                        .setSetFlags(Map.of(
                                MirrorStateFlag.DELETED, true
                        ))
                        .build());

        return actionEntryMap;
    }

    @Override
    protected Multistate<MirrorStateFlag> getMultistateForValue(Long multistateValue) {
        return new MirrorMultistate(multistateValue);
    }

    private ActionEntry.Builder<BaseMirror, MirrorStateFlag> getActionEntryBuilder(GettextMsg titleMsg) {
        return getActionEntryBuilder(titleMsg, Set.of(BaseMirror.ID, BaseMirror.MULTISTATE));
    }

    @Override
    public Class<BaseMirror> getModelClass() {
        return BaseMirror.class;
    }

    @Override
    public Multistate<MirrorStateFlag> convertMultistate(List<MirrorStateFlag> enabledFlags) {
        return new MirrorMultistate(enabledFlags);
    }
}
