package ru.yandex.partner.core.entity.mirror.filter;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.mirror.model.BaseMirror;
import ru.yandex.partner.core.filter.container.CommonModelFilterContainer;
import ru.yandex.partner.core.filter.db.NoDbFilter;
import ru.yandex.partner.core.filter.db.StringDbFilter;
import ru.yandex.partner.dbschema.partner.tables.InternalContextOnSiteMirrors;

@Component
public class InternalMirrorModelFilterContainer extends CommonModelFilterContainer<BaseMirror> {

    @Autowired
    public InternalMirrorModelFilterContainer() {
        super(List.of(
                new StringDbFilter<>(MirrorFilters.DOMAIN, BaseMirror.class,
                        InternalContextOnSiteMirrors.INTERNAL_CONTEXT_ON_SITE_MIRRORS.DOMAIN),
                new NoDbFilter<>(MirrorFilters.MULTISTATE, BaseMirror.class)
        ));
    }

    @Override
    public Class<BaseMirror> getModelClass() {
        return BaseMirror.class;
    }
}
