package ru.yandex.partner.core.entity.mirror.filter;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.mirror.model.BaseMirror;
import ru.yandex.partner.core.filter.container.CommonModelFilterContainer;
import ru.yandex.partner.core.filter.db.StringDbFilter;
import ru.yandex.partner.dbschema.partner.tables.ContextOnSiteMirrors;

@Component
public class MirrorModelFilterContainer extends CommonModelFilterContainer<BaseMirror> {

    @Autowired
    public MirrorModelFilterContainer(MirrorMultistateDbFilter mirrorMultistateGraphDbFilter) {
        super(List.of(new StringDbFilter<>(MirrorFilters.DOMAIN, BaseMirror.class,
                        ContextOnSiteMirrors.CONTEXT_ON_SITE_MIRRORS.DOMAIN),
                mirrorMultistateGraphDbFilter));
    }

    @Override
    public Class<BaseMirror> getModelClass() {
        return BaseMirror.class;
    }
}
