package ru.yandex.partner.core.entity.mirror.filter;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.mirror.MirrorMultistateGraph;
import ru.yandex.partner.core.entity.mirror.model.BaseMirror;
import ru.yandex.partner.core.filter.db.MultistateDbFilter;
import ru.yandex.partner.core.multistate.mirror.MirrorStateFlag;
import ru.yandex.partner.dbschema.partner.tables.ContextOnSiteMirrors;

@Component
public class MirrorMultistateDbFilter extends MultistateDbFilter<BaseMirror, MirrorStateFlag> {

    @Autowired
    public MirrorMultistateDbFilter(MirrorMultistateGraph multistateGraph) {
        super(MirrorFilters.MULTISTATE, BaseMirror.class, multistateGraph,
                ContextOnSiteMirrors.CONTEXT_ON_SITE_MIRRORS.MULTISTATE);
    }
}
