package ru.yandex.partner.core.entity.notification;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import static ru.yandex.partner.dbschema.partner.Tables.NOTIFICATION;

@Repository
public class NotificationRepository {
    private final DSLContext dslContext;

    @Autowired
    public NotificationRepository(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    // TODO: 06.05.2022 если понадобится доставать айдишки для нескольких нотификаций,
    // то стоит переделать на Map<String, Long>
//    @Cacheable(value = {CacheNames.CPM_CONVERT_NOTIFICATION_ID_CACHE}, unless = "#result == null")
    public Long getConvertCpmNotificationId() {
        return dslContext.select(NOTIFICATION.ID)
                .from(NOTIFICATION)
                .where(NOTIFICATION.SHORT_NAME.eq("cpm_convert_msg"))
                .fetchOne(NOTIFICATION.ID);
    }
}
