package ru.yandex.partner.core.entity.page.actions;

import org.jooq.DSLContext;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionUserIdContext;
import ru.yandex.partner.core.action.SimpleActionErrorHandler;
import ru.yandex.partner.core.action.log.AbstractActionsLogger;
import ru.yandex.partner.core.action.log.SimpleDbActionLogger;
import ru.yandex.partner.core.configuration.annotation.TransactionWithFallbackScope;
import ru.yandex.partner.core.entity.ModelQueryService;
import ru.yandex.partner.core.entity.page.ContextPageCopyMapper;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.entity.page.model.ContextPage;
import ru.yandex.partner.core.entity.page.repository.PageModifyRepository;
import ru.yandex.partner.core.entity.page.service.type.update.PageUpdateOperationTypeSupportFacade;
import ru.yandex.partner.core.entity.page.service.validation.type.PageValidationTypeSupportFacade;
import ru.yandex.partner.dbschema.partner.tables.ContextOnSiteCampaignActionLog;
import ru.yandex.partner.dbschema.partner.tables.records.ContextOnSiteCampaignActionLogRecord;
import ru.yandex.partner.defaultconfiguration.PartnerLocalDateTime;

@Configuration
public class ContextPageActionConfig {
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    @Bean
    @SuppressWarnings("checkstyle:parameternumber")
    ContextPageActionContext contextPageActionContext(
            DSLContext dslContext,
            ModelQueryService<BasePage> modelQueryService,
            ContextPageCopyMapper contextPageCopyMapper,
            PageUpdateOperationTypeSupportFacade updateOperationTypeSupport,
            PageModifyRepository pageModifyRepository,
            PageValidationTypeSupportFacade pageValidationTypeSupportFacade,
            AbstractActionsLogger<ContextOnSiteCampaignActionLogRecord> actionLogger,
            ActionErrorHandler<ContextPage> errorHandler
    ) {
        return new ContextPageActionContext(
                dslContext,
                actionLogger,
                errorHandler,
                modelQueryService,
                contextPageCopyMapper::copy,
                updateOperationTypeSupport,
                pageModifyRepository,
                pageValidationTypeSupportFacade
        );
    }

    @TransactionWithFallbackScope
    @Bean
    ActionErrorHandler<ContextPage> contextPageErrorHandler() {
        return new SimpleActionErrorHandler<>();
    }

    @Bean
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    AbstractActionsLogger<ContextOnSiteCampaignActionLogRecord>
    contextPageActionsLogger(DSLContext dslContext, ActionUserIdContext actionUserIdContext) {
        return new SimpleDbActionLogger<>(
                dslContext,
                ContextOnSiteCampaignActionLog.CONTEXT_ON_SITE_CAMPAIGN_ACTION_LOG,
                this::buildActionLogRecord,
                actionUserIdContext
        );
    }

    public ContextOnSiteCampaignActionLogRecord buildActionLogRecord(
            Long userId, Long modelId, long oldMultistate, String actionName, long newMultistate, String opts) {
        var record = new ContextOnSiteCampaignActionLogRecord();
        record.setDt(PartnerLocalDateTime.now());
        record.setUserId(userId);
        record.setElemId(modelId);
        record.setOldMultistate(oldMultistate);
        record.setAction(actionName);
        record.setNewMultistate(newMultistate);
        record.setOpts(opts);
        return record;
    }
}
