package ru.yandex.partner.core.entity.page.actions;

import java.util.function.Function;

import org.jooq.DSLContext;

import ru.yandex.direct.multitype.repository.TypeModifyRepository;
import ru.yandex.direct.multitype.service.type.update.UpdateOperationTypeSupportFacade;
import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.TypeSupportActionContext;
import ru.yandex.partner.core.action.log.ActionsLogger;
import ru.yandex.partner.core.entity.ModelQueryService;
import ru.yandex.partner.core.entity.page.container.PageOperationContainer;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.entity.page.model.ContextPage;
import ru.yandex.partner.core.multitype.service.validation.type.ValidationTypeSupportFacade;

public class ContextPageActionContext extends
        TypeSupportActionContext<BasePage, ContextPage, PageOperationContainer> {
    @SuppressWarnings("ParameterNumber")
    public ContextPageActionContext(
            DSLContext dslContext,
            ActionsLogger actionsLogger,
            ActionErrorHandler<ContextPage> actionErrorHandler,
            ModelQueryService<? super ContextPage> queryService,
            Function<ContextPage, ContextPage> copyFunction,
            UpdateOperationTypeSupportFacade<BasePage,
                    PageOperationContainer,
                    PageOperationContainer,
                    PageOperationContainer
                    > updateOperationTypeSupport,
            TypeModifyRepository<BasePage, BasePage, PageOperationContainer,
                                PageOperationContainer> pageModifyService,
            ValidationTypeSupportFacade<BasePage, PageOperationContainer, PageOperationContainer>
                    validationTypeSupportFacade
    ) {
        super(
                ContextPage.class,
                actionsLogger,
                actionErrorHandler,
                queryService,
                copyFunction,
                dslContext,
                updateOperationTypeSupport,
                pageModifyService,
                validationTypeSupportFacade,
                PageOperationContainer::create
        );
    }
}
