package ru.yandex.partner.core.entity.page.actions;

import org.jooq.DSLContext;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionUserIdContext;
import ru.yandex.partner.core.action.SimpleActionErrorHandler;
import ru.yandex.partner.core.action.log.ActionsLogger;
import ru.yandex.partner.core.action.log.SimpleDbActionLogger;
import ru.yandex.partner.core.configuration.annotation.TransactionWithFallbackScope;
import ru.yandex.partner.core.entity.ModelQueryService;
import ru.yandex.partner.core.entity.page.InternalContextPageCopyMapper;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.entity.page.model.InternalContextPage;
import ru.yandex.partner.core.entity.page.repository.PageModifyRepository;
import ru.yandex.partner.core.entity.page.service.type.update.PageUpdateOperationTypeSupportFacade;
import ru.yandex.partner.core.entity.page.service.validation.type.PageValidationTypeSupportFacade;
import ru.yandex.partner.dbschema.partner.tables.InternalContextOnSiteCampaignActionLog;
import ru.yandex.partner.dbschema.partner.tables.records.InternalContextOnSiteCampaignActionLogRecord;
import ru.yandex.partner.defaultconfiguration.PartnerLocalDateTime;

@Configuration
public class InternalContextPageActionConfig {
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    @Bean
    InternalContextPageActionContext internalContextPageActionContext(
            DSLContext dslContext,
            ModelQueryService<BasePage> modelQueryService,
            InternalContextPageCopyMapper pageCopyMapper,
            PageUpdateOperationTypeSupportFacade updateOperationTypeSupport,
            PageModifyRepository pageModifyRepository,
            PageValidationTypeSupportFacade pageValidationTypeSupportFacade,
            ActionUserIdContext actionUserIdContext
    ) {
        return new InternalContextPageActionContext(
                dslContext,
                internalContextPageActionsLogger(dslContext, actionUserIdContext),
                internalContextPageErrorHandler(),
                modelQueryService,
                pageCopyMapper::copy,
                updateOperationTypeSupport,
                pageModifyRepository,
                pageValidationTypeSupportFacade
        );
    }

    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    @Bean
    ActionErrorHandler<InternalContextPage> internalContextPageErrorHandler() {
        return new SimpleActionErrorHandler<>();
    }

    @Bean
    @TransactionWithFallbackScope
    ActionsLogger internalContextPageActionsLogger(DSLContext dslContext, ActionUserIdContext actionUserIdContext) {
        return new SimpleDbActionLogger<>(
                dslContext,
                InternalContextOnSiteCampaignActionLog.INTERNAL_CONTEXT_ON_SITE_CAMPAIGN_ACTION_LOG,
                this::buildActionLogRecord,
                actionUserIdContext
        );
    }

    public InternalContextOnSiteCampaignActionLogRecord buildActionLogRecord(
            Long userId, Long modelId, long oldMultistate, String actionName, long newMultistate, String opts) {
        var record = new InternalContextOnSiteCampaignActionLogRecord();
        record.setDt(PartnerLocalDateTime.now());
        record.setUserId(userId);
        record.setElemId(modelId);
        record.setOldMultistate(oldMultistate);
        record.setAction(actionName);
        record.setNewMultistate(newMultistate);
        record.setOpts(opts);
        return record;
    }
}
