package ru.yandex.partner.core.entity.page.actions;

import java.util.function.Function;

import org.jooq.DSLContext;

import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.TypeSupportActionContext;
import ru.yandex.partner.core.action.log.ActionsLogger;
import ru.yandex.partner.core.entity.ModelQueryService;
import ru.yandex.partner.core.entity.page.container.PageOperationContainer;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.entity.page.model.InternalContextPage;
import ru.yandex.partner.core.entity.page.repository.PageModifyRepository;
import ru.yandex.partner.core.entity.page.service.type.update.PageUpdateOperationTypeSupportFacade;
import ru.yandex.partner.core.entity.page.service.validation.type.PageValidationTypeSupportFacade;

public class InternalContextPageActionContext
        extends TypeSupportActionContext<BasePage, InternalContextPage, PageOperationContainer> {

    @SuppressWarnings("ParameterNumber")
    public InternalContextPageActionContext(
            DSLContext dslContext,
            ActionsLogger actionsLogger,
            ActionErrorHandler<InternalContextPage> actionErrorHandler,
            ModelQueryService<? super InternalContextPage> queryService,
            Function<InternalContextPage, InternalContextPage> copyFunction,
            PageUpdateOperationTypeSupportFacade updateOperationTypeSupport,
            PageModifyRepository pageModifyService,
            PageValidationTypeSupportFacade validationTypeSupportFacade
    ) {
        super(
                InternalContextPage.class,
                actionsLogger,
                actionErrorHandler,
                queryService,
                copyFunction,
                dslContext,
                updateOperationTypeSupport,
                pageModifyService,
                validationTypeSupportFacade,
                PageOperationContainer::create
        );
    }
}
