package ru.yandex.partner.core.entity.page.actions;

import org.jooq.DSLContext;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionUserIdContext;
import ru.yandex.partner.core.action.SimpleActionErrorHandler;
import ru.yandex.partner.core.action.log.AbstractActionsLogger;
import ru.yandex.partner.core.action.log.SimpleDbActionLogger;
import ru.yandex.partner.core.configuration.annotation.TransactionWithFallbackScope;
import ru.yandex.partner.core.entity.ModelQueryService;
import ru.yandex.partner.core.entity.page.InternalMobileAppCopyMapper;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.entity.page.model.InternalMobileApp;
import ru.yandex.partner.core.entity.page.repository.PageModifyRepository;
import ru.yandex.partner.core.entity.page.service.type.update.PageUpdateOperationTypeSupportFacade;
import ru.yandex.partner.core.entity.page.service.validation.type.PageValidationTypeSupportFacade;
import ru.yandex.partner.dbschema.partner.tables.InternalMobileAppActionLog;
import ru.yandex.partner.dbschema.partner.tables.records.InternalMobileAppActionLogRecord;
import ru.yandex.partner.defaultconfiguration.PartnerLocalDateTime;

@Configuration
public class InternalMobileAppActionConfig {
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    @Bean
    @SuppressWarnings("checkstyle:parameternumber")
    InternalMobileAppActionContext internalMobileAppActionContext(
            DSLContext dslContext,
            ModelQueryService<BasePage> modelQueryService,
            InternalMobileAppCopyMapper mobileAppCopyMapper,
            PageUpdateOperationTypeSupportFacade updateOperationTypeSupport,
            PageModifyRepository pageModifyRepository,
            PageValidationTypeSupportFacade pageValidationTypeSupportFacade,
            AbstractActionsLogger<InternalMobileAppActionLogRecord> actionLogger,
            ActionErrorHandler<InternalMobileApp> errorHandler
    ) {
        return new InternalMobileAppActionContext(
                dslContext,
                actionLogger,
                errorHandler,
                modelQueryService,
                mobileAppCopyMapper::copy,
                updateOperationTypeSupport,
                pageModifyRepository,
                pageValidationTypeSupportFacade
        );
    }

    @TransactionWithFallbackScope
    @Bean
    ActionErrorHandler<InternalMobileApp> internalMobileAppErrorHandler() {
        return new SimpleActionErrorHandler<>();
    }

    @Bean
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    AbstractActionsLogger<InternalMobileAppActionLogRecord>
    internalMobileAppActionsLogger(DSLContext dslContext, ActionUserIdContext actionUserIdContext) {
        return new SimpleDbActionLogger<>(
                dslContext,
                InternalMobileAppActionLog.INTERNAL_MOBILE_APP_ACTION_LOG,
                this::buildActionLogRecord,
                actionUserIdContext
        );
    }

    public InternalMobileAppActionLogRecord buildActionLogRecord(
            Long userId, Long modelId, long oldMultistate, String actionName, long newMultistate, String opts) {
        var record = new InternalMobileAppActionLogRecord();
        record.setDt(PartnerLocalDateTime.now());
        record.setUserId(userId);
        record.setElemId(modelId);
        record.setOldMultistate(oldMultistate);
        record.setAction(actionName);
        record.setNewMultistate(newMultistate);
        record.setOpts(opts);
        return record;
    }
}
