package ru.yandex.partner.core.entity.page.actions;

import java.util.function.Function;

import org.jooq.DSLContext;

import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.TypeSupportActionContext;
import ru.yandex.partner.core.action.log.ActionsLogger;
import ru.yandex.partner.core.entity.ModelQueryService;
import ru.yandex.partner.core.entity.page.container.PageOperationContainer;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.entity.page.model.InternalMobileApp;
import ru.yandex.partner.core.entity.page.repository.PageModifyRepository;
import ru.yandex.partner.core.entity.page.service.type.update.PageUpdateOperationTypeSupportFacade;
import ru.yandex.partner.core.entity.page.service.validation.type.PageValidationTypeSupportFacade;

public class InternalMobileAppActionContext extends TypeSupportActionContext<BasePage, InternalMobileApp,
        PageOperationContainer> {
    @SuppressWarnings("ParameterNumber")
    public InternalMobileAppActionContext(
            DSLContext dslContext,
            ActionsLogger actionsLogger,
            ActionErrorHandler<InternalMobileApp> actionErrorHandler,
            ModelQueryService<? super InternalMobileApp> queryService,
            Function<InternalMobileApp, InternalMobileApp> copyFunction,
            PageUpdateOperationTypeSupportFacade updateOperationTypeSupport,
            PageModifyRepository pageModifyRepository,
            PageValidationTypeSupportFacade validationTypeSupportFacade
    ) {
        super(
                InternalMobileApp.class,
                actionsLogger,
                actionErrorHandler,
                queryService,
                copyFunction,
                dslContext,
                updateOperationTypeSupport,
                pageModifyRepository,
                validationTypeSupportFacade,
                PageOperationContainer::create
        );
    }
}
